(function() {
  //    FILE:Object Browser
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 10/16/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'Backbone.LocalStorage', 'collections/objects/ObjectCollection', 'models/objects/ObjectModel', "views/event/EventSheetView", "views/event/EventDayPlanView", 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, LocalStorage, ObjectCollection, ObjectModel, EventSheetView, EventDayPlanView) {
    var ObjectFolderBrowserView;
    return ObjectFolderBrowserView = class ObjectFolderBrowserView extends Backbone.View {
      initialize(usr, context) {
        this.usr = usr;
        this.context = context;
        this.objectsCol = new ObjectCollection();
        this.objectsCol.on('collectionObjectsFilled', this.collectionObjectsFilled, this);
        this.objectsCol.on('collectionFavObjectsFilled', this.collectionFavObjectsFilled, this);
        return this.folders = [];
      }

      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap #id-btn-back': 'btnBackClicked',
          'pageshow': 'pageShown',
          'tap #id-ul-objectMainBrowser > li': 'liObjectClicked',
          'tap #id-ul-objectBrowser > li': 'liObjectClicked',
          'tap #id-ul-favoriteObjects > li': 'liObjectClicked',
          'tap #id-ul-objectFolder > li': 'liObjectFolderClicked',
          'tap #id-ul-objectFolder-Objects > li': 'liObjectClicked',
          'tap #id-btn-backMainList': 'btnBackMainList',
          'tap #id-btn-backObjectFolder': 'btnBackObjectFolder',
          'tap #id-btn-search-object': 'btnSearchClicked',
          'tap .btn-submenu-objectbrowser': 'subMenuObjectBrowserClicked',
          //      'change #id-select-object': 'changedSearchFilter'
          'tap .favorite-span': 'favStarClicked',
          'tap #id-btn-editmode': 'btnEditModeClicked'
        };
      }

      render() {
        var ref, template;
        template = Handlebars.templates['ObjectFolderBrowserView'];
        this.$el.html(template({
          usr: this.usr.toJSON(),
          context: this.context
        }));
        this.$el.attr('id', 'id-ObjectFolderBrowserView');
        if (this.context === 'EventsViewing' || (((ref = this.context) === 'TimereportExtra' || ref === 'TaskInvolved' || ref === 'BookingInvolved' || ref === 'AdhocInvolved') && window.media_query_min_width(768))) {
          return this.addSidePanel();
        }
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        var MenuView;
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      subMenuObjectBrowserClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        this.$el.find('.subObjectBrowserView').hide();
        if (id === '#id-divObjectBrowserFavorites') {
          this.$el.find('#id-btn-editmode').show();
          //CHEC IF CROSS IS SHOWED AND CHANGE IT TO EDIT MODE
          if (this.$el.find('#id-btn-editmode').find('span.fwi-cross-cancel').length > 0) {
            this.$el.find('#id-btn-editmode').find('span.fwi-cross-cancel').removeClass('fwi-cross-cancel').addClass('fwi-edit');
            this.$el.find('#id-ul-favoriteObjects > li > span.favorite-span').hide();
            this.$el.find('#id-btn-editmode').attr('data-state', 'off');
          }
        } else {
          this.$el.find('#id-btn-editmode').hide();
        }
        return $(id).show();
      }

      btnEditModeClicked(event) {
        var btn;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (btn.attr('data-state') === 'off') {
          this.$el.find('#id-ul-favoriteObjects > li > span.favorite-span').show();
          btn.find('span.fwi-edit').removeClass('fwi-edit').addClass('fwi-cross-cancel');
          return btn.attr('data-state', 'on');
        } else {
          this.$el.find('#id-ul-favoriteObjects > li > span.favorite-span').hide();
          btn.find('span.fwi-cross-cancel').removeClass('fwi-cross-cancel').addClass('fwi-edit');
          return btn.attr('data-state', 'off');
        }
      }

      pageShown() {
        this.objectsCol.get_simple_objects(this.usr);
        //RESETING TITLE IN CASE WE ARE COMING BACK FROM EVENT LIST
        this.$el.find('#id-h1-navbar-title').text('Object Browser');
        //CHEC IF CROSS IS SHOWED AND CHANGE IT TO EDIT MODE
        if (this.$el.find('#id-btn-editmode').find('span.fwi-cross-cancel').length > 0) {
          this.$el.find('#id-btn-editmode').find('span.fwi-cross-cancel').removeClass('fwi-cross-cancel').addClass('fwi-edit');
        }
        //SELECT TAB
        if (this.$el.find('#id-divObjectBrowserSearch').is(':visible')) {
          this.$el.find('#id-submenu-objectbrowser-search').addClass('ui-btn-active');
          this.$el.find('#id-submenu-objectbrowser-favorites').removeClass('ui-btn-active');
          return this.$el.find('#id-submenu-objectbrowser-categories').removeClass('ui-btn-active');
        } else if (this.$el.find('#id-divObjectBrowserCategories').is(':visible')) {
          this.$el.find('#id-submenu-objectbrowser-categories').addClass('ui-btn-active');
          this.$el.find('#id-submenu-objectbrowser-search').removeClass('ui-btn-active');
          return this.$el.find('#id-submenu-objectbrowser-favorites').removeClass('ui-btn-active');
        } else {
          this.$el.find('#id-submenu-objectbrowser-favorites').addClass('ui-btn-active');
          this.$el.find('#id-submenu-objectbrowser-search').removeClass('ui-btn-active');
          return this.$el.find('#id-submenu-objectbrowser-categories').removeClass('ui-btn-active');
        }
      }

      collectionObjectsFilled() {
        //NOW THE BIG OBJECT COLLECTION IS FILLED - WE PRINT THE FAV LIST  (IF INVOLVED FOR TASK)
        this.objectsCol.get_favorites_objects(this.usr);
        this.update_objectfolder_list();
        this.$el.find('#id-input-search-object').textinput('enable');
        return this.$el.find('#id-btn-search-object').show();
      }

      collectionFavObjectsFilled() {
        this.$el.find('#id-spinner-all').hide();
        return this.update_favorite_list();
      }

      btnSearchClicked(event) {
        var col, input, li, query, ulc;
        this.$el.find('#id-spinner').show();
        input = this.$el.find('#id-input-search-object');
        query = input.val();
        if (query.length >= 3) { //ONLY SEARCH WITH +3 CHAR
          col = this.objectsCol.findByName(query, this.context);
          this.update_object_list(col);
          //Show Selected Filter
          //        @changedSearchFilter(event,@$el.find('#id-select-object').val())
          this.$el.find('#id-ul-objectMainBrowser').show();
          return this.$el.find('#id-ul-objectBrowser').hide();
        } else {
          this.$el.find('#id-spinner').hide();
          ulc = this.$el.find('#id-ul-objectMainBrowser');
          ulc.empty();
          li = '<li>You need at least 3 characters</li>';
          ulc.append(li);
          return ulc.listview('refresh');
        }
      }

      update_favorite_list() {
        var col, display, favorites, ulf;
        favorites = this.objectsCol.get_favorites_from_context(this.context);
        ulf = this.$el.find('#id-ul-favoriteObjects');
        ulf.empty();
        display = 'style="display: none;"';
        if (this.objectsCol.models.length > 1) {
          col = this.objectsCol.toJSON();
        } else {
          col = this.objectsCol.models[0].toJSON();
        }
        _.each(favorites, (f) => {
          var icon, li, name, obj;
          obj = _.findWhere(col, {
            objectID: f
          });
          if (obj) {
            icon = this.__get_object_icon(obj);
            if (icon === 'fwi-object-browser') {
              if (obj.type === "dayPlan") {
                name = "(day-plan)";
              } else {
                name = "";
              }
              li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"fav\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\"><span class=\"fwi-obj-browser object-span\"/><span class='text-span'> ${obj.name} ${name}</span><span class='fwi-star favorite-span' ${display} /></li>`;
            } else if (icon === 'fwi-contact') {
              li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"fav\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\"><span class=\"fwi-contact object-span\"/><span class='text-span'> ${obj.name}</span><span class='fwi-star favorite-span' ${display} /></li>`;
            } else {
              li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"fav\" data-objectID=\"${obj.objectID}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-obj object-span\" /><span class='text-span'> ${obj.name}</span><span class='fwi-star favorite-span' ${display}/> </li>`;
            }
          }
          return ulf.append(li);
        });
        if (ulf.find('li').length === 0) {
          ulf.append('<li data-objectID="empty"><span class="text-span">You don\'t have any Favourite Object yet</span></li>');
        }
        ulf.listview();
        return ulf.listview('refresh');
      }

      update_objectfolder_list() {
        var clsLi, objF, ul;
        objF = JSON.parse(window.localStorage.getItem('ObjectFolders'));
        ul = this.$el.find('#id-ul-objectFolder');
        ul.empty();
        _.each(objF, (cat) => {
          var li;
          if (this.objectsCol.is_object_folder_viewable(cat, this.context)) {
            li = `<li data-objectServerType=\"${cat.type}\" ><span class='text-span'> ${cat.name} </span>`;
            li += "<span class='fwi-arrow-right arrow-right'/></li>";
            return ul.append(li);
          }
        });
        clsLi = "<li data-objectServerType=\"objectClass\" ><span class='text-span'> Classes </span>";
        clsLi += "<span class='fwi-arrow-right arrow-right'/></li>";
        ul.append(clsLi);
        ul.listview();
        return ul.listview('refresh');
      }

      update_object_list(col) {
        var li, ulc;
        ulc = this.$el.find('#id-ul-objectMainBrowser');
        ulc.empty();
        if (col.length > 0) {
          _.each(col, (obj) => {
            var favClass, icon, isFav, li, name, objType;
            if (this.objectsCol.is_object_viewable(obj, this.context)) {
              if (obj.name) {
                isFav = this.__is_favorite(obj.objectID);
                favClass = 'nofavorite';
                if (isFav) {
                  favClass = '';
                }
                icon = this.__get_object_icon(obj);
                if (icon === 'fwi-object-browser') {
                  if (obj.type === "dayPlan") {
                    name = "(day-plan)";
                  } else {
                    name = "";
                  }
                  objType = 'objCls';
                  li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-obj-browser object-span\"/><span class='text-span'> ${obj.name} ${name}</span><span class=\"fwi-star favorite-span ${favClass}\"  /></li>`;
                } else if (icon === 'fwi-contact') {
                  objType = 'con';
                  li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\"  ><span class=\"fwi-contact object-span\"/><span class='text-span'> ${obj.name} </span><span class=\"fwi-star favorite-span ${favClass}\"  /></li>`;
                } else {
                  objType = 'obj';
                  li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectClassID=\"${obj.objectClassID}\"  ><span class=\"fwi-obj object-span\"/><span class='text-span'> ${obj.name}</span><span class=\"fwi-star favorite-span ${favClass}\" /> </li>`;
                }
                return ulc.append(li);
              }
            }
          });
        } else {
          li = '<li>0 Objects found</li>';
          ulc.append(li);
        }
        this.$el.find('#id-spinner-all').hide();
        return ulc.listview('refresh');
      }

      liObjectFolderClicked(event) {
        var col, cur, members, objC, objF, objType, objs, ref, ref1, ul;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        objType = cur.attr('data-objectServerType');
        if (objType !== 'objectClass') {
          //GET OBJECTS MEMBERS IDS
          objF = JSON.parse(window.localStorage.getItem('ObjectFolders'));
          members = (ref = _.findWhere(objF, {
            type: objType
          })) != null ? (ref1 = ref.OFM) != null ? ref1.objectID : void 0 : void 0;
          if (!_.isArray(members)) {
            members = [members];
          }
          if (this.objectsCol.models.length > 1) {
            col = this.objectsCol.toJSON();
          } else {
            col = this.objectsCol.models[0].toJSON();
          }
          objs = [];
          _.each(members, function(id) {
            var ref2;
            return objs.push((ref2 = _.where(col, {
              objectID: id
            })) != null ? ref2[0] : void 0);
          });
          ul = this.$el.find('#id-ul-objectFolder-Objects');
          ul.empty();
          _.each(objs, (obj) => {
            var favClass, icon, isFav, li, name;
            isFav = this.__is_favorite(obj.objectID);
            favClass = 'nofavorite';
            if (isFav) {
              favClass = '';
            }
            icon = this.__get_object_icon(obj);
            if (icon === 'fwi-object-browser') {
              if (obj.type === "dayPlan") {
                name = "(day-plan)";
              } else {
                name = "";
              }
              li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-obj-browser object-span\"/><span class='text-span'> ${obj.name} ${name}</span><span class=\"fwi-star favorite-span ${favClass}\"  /></li>`;
            } else if (icon === 'fwi-contact') {
              li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-contact object-span\"/><span class='text-span'> ${obj.name} </span><span class=\"fwi-star favorite-span ${favClass}\"  /></li>`;
            } else {
              li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectID}\"  data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-obj object-span\"/><span class='text-span'> ${obj.name}</span><span class=\"fwi-star favorite-span ${favClass}\" /> </li>`;
            }
            return ul.append(li);
          });
          //SET TITLE
          this.$el.find('#id-h1-navbar-title').text(cur.text());
          this.$el.find('#id-btn-backObjectFolder').show();
          //HIDE LIST OF CATEGORIES
          this.$el.find('#id-ul-objectFolder').hide();
          //Show LIST OF OBJECTS
          this.$el.find('#id-ul-objectFolder-Objects').show();
          ul.listview();
          return ul.listview('refresh'); // WE CLICKED IN A CLASS
        } else {
          ul = this.$el.find('#id-ul-objectFolder-Objects');
          ul.empty();
          objC = JSON.parse(window.localStorage.getItem('ObjectClasses'));
          _.each(objC, function(obj) {
            var li;
            li = `<li data-objectServerType=\"${objType}\" data-objectLocalType=\"${objType}\" data-objectID=\"${obj.objectClassID}\" data-objectViewName=\"${obj.name}\" ><span class=\"fwi-obj-browser object-span\"/><span class='text-span'> ${obj.name}</span></li>`;
            return ul.append(li);
          });
          //SET TITLE
          this.$el.find('#id-h1-navbar-title').text('Classes');
          this.$el.find('#id-btn-backObjectFolder').show();
          //HIDE LIST OF CATEGORIES
          this.$el.find('#id-ul-objectFolder').hide();
          //Show LIST OF OBJECTS
          this.$el.find('#id-ul-objectFolder-Objects').show();
          ul.listview();
          return ul.listview('refresh');
        }
      }

      liObjectClicked(event) {
        var cur, iView, obj, objClassID, objID, objName, objType, objViewName, view;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        objName = cur.text();
        objID = cur.attr('data-objectID');
        objType = cur.attr('data-objectServerType');
        objViewName = cur.attr('data-objectViewName');
        objClassID = cur.attr('data-objectClassID');
        if (objID === 'empty') {
          return;
        }
        if (this.context === 'EventsViewing') {
          obj = new ObjectModel({
            previousView: 'objectBrowser'
          });
          obj.on('change', this.showEventList, this);
        }
        if (this.context === 'TimereportExtra') {
          obj = new ObjectModel({
            quantity: '1'
          });
          obj.on('change', this.addedExtra, this);
        }
        if (this.context === 'TaskInvolved') {
          if (objType === 'objectClass') {
            return;
          }
          obj = new ObjectModel();
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          obj.on('change', _.bind(view.addedTaskInvolved, this, view));
        }
        if (this.context === 'BookingInvolved') {
          if (objType === 'objectClass') {
            return;
          }
          obj = new ObjectModel();
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          obj.on('change', _.bind(view.addedBookingInvolved, this, view));
        }
        if (this.context === 'AdhocInvolved') {
          if (objType === 'objectClass') {
            return;
          }
          obj = new ObjectModel();
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          obj.on('change', _.bind(view.addedAdhocInvolved, this, view));
        }
        /*
        Last true parameter is because we have the data locally storaged, and we dont need extra info from the detail_object call
        AVOIDING A NETWORK CALL
        */
        return obj.set_object_detail(this.usr, objName, objID, objType, objViewName, objClassID);
      }

      favStarClicked(event) {
        var cur, groupName, li, name, noFav, obj, objID, objType;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        noFav = cur.hasClass('nofavorite');
        li = cur.parent();
        objID = li.attr('data-objectID');
        if (!objID) {
          objID = li.attr('data-objectClassID'); //IF NO ID, MEANS IT IS AN OBJECTCLASS SO WE GET THAT ID
        }
        objType = li.attr('data-objectServerType');
        name = li.text();
        if (this.context === 'EventsViewing') {
          groupName = 'FavoritesForViewingEvents';
        }
        if (this.context === 'TimereportExtra') {
          groupName = 'FavoritesForAddingToExtras';
        }
        if (this.context === 'TaskInvolved') {
          groupName = 'FavoritesForAddingToEvents';
        }
        if (this.context === 'BookingInvolved') {
          groupName = 'FavoritesForAddingToEvents';
        }
        obj = new ObjectModel({
          objectID: objID,
          type: objType,
          groupName: groupName,
          name: name,
          objectClassID: li.attr('data-objectClassID')
        });
        // FOR THE MOMENT IS ONLY SUPPORT VIEWING EVENTS OF OBJECTS
        obj.on('addedFavorite', _.bind(this.addedFavorite, this, obj));
        obj.on('removedFavorite', _.bind(this.removedFavorite, this, obj));
        if (noFav) {
          //WE CHANGE TO FAVORITE
          cur.removeClass('nofavorite');
          return obj.set_favorite(this.usr, objID, objType, groupName, true);
        } else {
          cur.addClass('nofavorite');
          return obj.set_favorite(this.usr, objID, objType, groupName, false);
        }
      }

      btnBackMainList(event) {
        event.preventDefault();
        event.stopPropagation();
        this.$el.find('#id-btn-backMainList').hide();
        this.$el.find('#id-div-wrapper-searchcontrols').show();
        //HIDE OBJECT LIST
        this.$el.find('#id-ul-objectBrowser').hide();
        this.$el.find('#id-ul-objectMainBrowser').show();
        return this.$el.find('#id-h1-navbar-title').text('Object Browser');
      }

      btnBackObjectFolder(event) {
        event.preventDefault();
        event.stopPropagation();
        this.$el.find('#id-h1-navbar-title').text('Categories');
        this.$el.find('#id-ul-objectFolder-Objects').hide();
        this.$el.find('#id-btn-backObjectFolder').hide();
        return this.$el.find('#id-ul-objectFolder').show();
      }

      showEventList(objMdl) {
        var EventCollection, EventListView, ev, objID, type, view;
        //### ASK FOR EVENTS TOO MISSING OBJECT ID CUSTOM
        if (!EventCollection) {
          EventCollection = require("collections/event/EventCollection");
        }
        if (!EventListView) {
          EventListView = require("views/event/EventListView");
        }
        if (!EventSheetView) {
          EventSheetView = require("views/event/EventSheetView");
        }
        if (!EventDayPlanView) {
          EventDayPlanView = require("views/event/EventDayPlanView");
        }
        ev = new EventCollection();
        ev.set_day_events(this.usr, null, objMdl);
        type = objMdl.get('objectType');
        objID = objMdl.get('objectID');
        if ((type === 'sharedEventsView' || type === 'objectClass' || type === 'smartEventsView' || type === 'allEvents') && objID !== 'myEvents') {
          view = new EventSheetView(this.usr, ev, objMdl);
        } else if (type === 'dayPlan') {
          view = new EventDayPlanView(this.usr, ev, objMdl);
        } else {
          view = new EventListView(this.usr, ev, objMdl);
        }
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      addedExtra(objMdl) {
        var li, ulExtra;
        //NOT SUPER NICE - SINCE WE ARE SURE WE COME FROM TIMEREPORTS - WE CAN ADD THE EXTRA DIRECTLY TO DOM
        ulExtra = $('#id-ul-extras');
        ulExtra.attr('data-addExtra', '1');
        if (ulExtra) {
          li = `<li data-extraID=\"${objMdl.get('extraID')}\" data-activityID=\"${objMdl.get('activityID')}\" data-objectID=\"${objMdl.get('objectID')}\" data-objectType=\"${objMdl.get('objectType')}\" data-quantity=\"${objMdl.get('quantity')}\" data-note=\"${objMdl.get('note')}\"> <span class=\"quantity\">${objMdl.get('quantity')}</span><span class=\"name\"> ${objMdl.get('objectName')}</span><span class=\"fwi-edit edit-right\"/> <div class=\"extra-info\" style=\"display: none;\" data-role=\"fieldcontain\"> <input type=\"number\" class=\"input-quantity\" value=\"${objMdl.get('quantity')}\" placeholder=\"Quantity\"/> <textarea placeholder=\"Extra Note\"></textarea> <div class=\"wrapper-btn\"> <span class=\"btn btn-delete-extra\"> Delete </span> <span class=\"btn btn-done-extra\"> Done </span> </div> </div> </li>`;
          ulExtra.append(li);
          ulExtra.listview('refresh');
        }
        $('.extra-info').trigger('create');
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      addedFavorite(objMdl) {
        var display, icon, li, name, obj, ulf;
        this.objectsCol.add_favorite_with_context(objMdl, this.context);
        obj = objMdl.toJSON();
        ulf = this.$el.find('#id-ul-favoriteObjects');
        if (ulf.find('li[data-objectID="empty"]').length === 1) {
          ulf.empty();
        }
        // WE CHECK IF WE ARE IN EDIT MODE
        display = 'style="display: none;"';
        icon = this.__get_object_icon(obj);
        if (icon === 'fwi-object-browser') {
          if (obj.type === "dayPlan") {
            name = "(day-plan)";
          } else {
            name = "";
          }
          li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"fav\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\"><span class=\"fwi-obj-browser object-span\"/><span class='text-span'> ${obj.name} ${name}</span><span class='fwi-star favorite-span' ${display} /></li>`;
        } else if (icon === 'fwi-contact') {
          li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"fav\" data-objectID=\"${obj.objectID}\" data-objectViewName=\"${obj.name}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-contact object-span\"/><span class='text-span'> ${obj.name} </span><span class='fwi-star favorite-span' ${display} /></li>`;
        } else {
          li = `<li data-objectServerType=\"${obj.type}\" data-objectLocalType=\"fav\" data-objectID=\"${obj.objectID}\" data-objectClassID=\"${obj.objectClassID}\" ><span class=\"fwi-obj object-span\"/><span class='text-span'> ${obj.name}</span><span class='fwi-star favorite-span' ${display}/> </li>`;
        }
        ulf.append(li);
        return ulf.listview('refresh');
      }

      removedFavorite(objMdl) {
        var id, li;
        id = objMdl.get('objectID');
        this.objectsCol.remove_favorite_with_context(objMdl, this.context);
        li = this.$el.find('#id-ul-favoriteObjects > li[data-objectid="' + id + '"]');
        return li.remove();
      }

      __is_favorite(id) {
        var li;
        li = this.$el.find('#id-ul-favoriteObjects > li[data-objectid="' + id + '"]');
        if (li.length > 0) {
          return true;
        } else {
          return false;
        }
      }

      __get_object_icon(obj) {
        if (obj.type === 'objectClass' || obj.type === "smartEventsView" || obj.type === "dayPlan" || obj.type === "sharedEventsView" || (obj.type === 'smartEventsView' && obj.objectID === 'allEvents')) {
          return 'fwi-object-browser';
        } else if (obj.type.indexOf('user') !== -1 || obj.type === 'resource' || (obj.type === 'smartEventsView' && obj.objectID === 'myEvents') || (obj.type === 'smartEventsView' && obj.objectID === 'myRelatedEvents')) {
          return 'fwi-contact';
        } else {
          return 'fwi-obj';
        }
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
